#! /usr/bin/tclsh
############################################
# tksurfer script: pialwhitethk.tcl
############################################
# tksurfer marser $hemi orig -tcl pialwhitethk.tcl

### wrap script so errors/crash to log
catch {

### for testing
set dopialflag 1
set dowhiteflag 1
set dothicknessflag 1

if {$dopialflag || $dowhiteflag} {
  ### closeup view
  read_binary_curv
  open_window
  make_lateral_view
  do_lighting_model
  scale_brain 5.0
  redraw
  update

  ### load surface
  setfile insurf ~/surf/$hemi.smoothwm
  read_binary_surface

  ### load 3D vols
  setfile inim ~/mri/brain.mgz
  read_images
  setfile inim2 ~/mri/filled.mgz
  read_images2
  setfile inim3 ~/mri/T2.mgz
  read_images3
}

if {$dopialflag} {
  ##########################################
  # pial SHRINK
  ##########################################
  ### SHRINK: T1 + selfintersect + filled + on/off T2
  set forcemode 0          ;# samp T1 at surf only
  set ws 0.5               ;# neighbor
  set wn 0.5               ;# normal
  set mmid 45.0            ;# targ T1 val
  set mstrength 0.08       ;# T1 force
  set selfstilt -0.85      ;# neg->in (-0.75 stuck)
  set chkthird_lolim 60    ;# IT/cereb
  set chkthird_hilim 120   ;# IT/cereb

  ### SHRINK: main
  set MRIflag 1            ;# use T1
  set chkselfintflag 1     ;# sulci
  set chkfilledflag 1      ;# midbrain/CC
  set chkthirdflag 1       ;# dura IT/cereb
  set chkgradampflag 0     ;# grad amp for WM
  clear_selfintersect

#CURR: 40->45, 1.0-> -0.85, back and forth
  ### SHRINK: basic + interleaved T2 lumps off
  set i 0
  while {$i < 8} {  ;# ~1000 steps
    set chkthirdflag 1
    runshrink 5 25 0
    set chkthirdflag 0
    runshrink 1 5 0
    incr i
  }

### pretty similar
#  ### SHRINK: basic, then 3rd off for T2 lumps
#  set mmid 40.0
#  set selfstilt -1.0
#  set chkthirdflag 1
#  runshrink 5 200 0
#  set chkthirdflag 0
#  runshrink 5 4 0

  ### SHRINK: relax
  set MRIflag 0
  set chkselfintflag 0
  set chkfilledflag 0
  set chkthirdflag 0
  set chkgradampflag 0
  runshrink 1 3 0

  ### write pial surf
  #setfile outsurf ~/surf/$hemi.pial
  setfile outsurf ~/surf/$hemi.pialtmp
  write_binary_surface
}

if {$dowhiteflag} {
  ##########################################
  # white SHRINK
  ##########################################
  set forcemode 0
  set ws 0.5
  set wn 1.0             ;# turn up
  set mmid 105.0         ;# turn up
  set mstrength 0.125    ;# turn up
  set selfstilt 0.85     ;# pos->out
  set selfstilt 1.0      ;# pos->out

  set MRIflag 1
  set chkselfintflag 1
  set chkfilledflag 0
  set chkthirdflag 0
  set chkgradampflag 1   ;# gradient ampl
  clear_selfintersect

  ### reload surface (volume data still loaded)
  setfile insurf ~/surf/$hemi.smoothwm
  read_binary_surface

  ### SHRINK: main
  runshrink 5 100 0

  ### SHRINK: relax
  set MRIflag 0
  set chkselfintflag 0
  set chkfilledflag 0
  set chkthirdflag 0
  set chkgradampflag 0
  runshrink 1 3 0

  ### write white surf
  #setfile outsurf ~/surf/$hemi.white
  setfile outsurf ~/surf/$hemi.whitetmp
  write_binary_surface
}

if {$dothicknessflag} {
  ##########################################
  # calc thickness w/MGH binary
  ##########################################
  # run inside clean subshell
  set ftmpcsh /tmp/TmpCshMgh.[pid]
  set command "mris_thickness $subject $hemi $hemi.thickness"
  set id [open $ftmpcsh w 0755]
  puts $id "#! /bin/csh -f"
  puts $id "setenv FREESURFER_HOME $env(FSURF_DIR)"
  puts $id "source \$FREESURFER_HOME/SetUpFreeSurfer.csh"
  puts $id $command
  close $id
  puts "#########################################"
  puts "[exec cat $ftmpcsh]"
  puts "#########################################"
  set command "csh $ftmpcsh"
  puts [eval exec $command |& cat]  ;# stdout+stderr
  exec rm $ftmpcsh
}

### errors (if any) to log
} ret 
if {$ret != ""} { puts "tksurfer: [file tail $script]: ### $ret" }

#if ![info exists noexit] { exit }

