#! /usr/local/bin/tclsh7.4
#############################################################################
# tksurfer script: flatten   [offline, justview, or movie of flattening]
#############################################################################

#### viewing,movie defaults: can reset in csh script with setenv
set viewlevel 0       ;# 0=offline, 1=justview, 2=savemovie
set dispcurv 0        ;# display curv
set dispsulc 0        ;# display sulc
set dispareashear 1   ;# display areashear
set savesteps 0       ;# save intermed patch files for subsequent movie (rare)

#### file defaults: can reset in csh script with setenv
set inpatch $hemi.patch
set outpatch $hemi.patch
set rgbname flattenmovie
#setfile rgbdir some_other_dir   ;# comment in, or type at prompt

#### parm defaults: can reset in csh script with setenv
set wa 0.8              ;# area
set wsh 0.8             ;# shear
set wt 0.5              ;# area/shear boundary normal??
set wbn 0.5             ;# area/shear boundary normal??
set ws 0.5              ;# tangential
set wn 0.0              ;# normal
set momentumflag 1
set flag2d 1            ;# use area shear
set avgflag 1           ;# make half convex/concave
set fthresh 0.0         ;# val/curv sigmoid zero (neg=>0)
set flatzrot 60         ;# arrange calcarine cut
set flatscale 1.3
set shrinkcycles 50
set fshrinksteps 20

#### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(MRI_DIR)/lib/tcl/readenv.tcl

#### read patch (default overwrites initial surface read in)
puts "tksurfer: [file tail $script]: read patch"
setfile patch ~/surf/$inpatch
read_binary_patch

#### should be default to save cuts in 3-D vs. init flat
if [string match *.3d $inpatch] { flatten }

#### scale and position brain if viewing
if {$viewlevel > 0} {
  puts "tksurfer: [file tail $script]: scale, position brain"
  open_window
  restore                    ;# patch: restore_zero_position,rotate_brain_x -90
  rotate_brain_z $flatzrot   ;# put calcarine cut to left
  scale_brain $flatscale
  redraw
}

#### flatten and make movie
shrink 0                   ;# to calculate shear
set i 0
while {$i <= $shrinkcycles} {

  if {$i != 0} { shrink $fshrinksteps }   ;# skip first cycle so initial saved
  normalize_area

  if {$viewlevel > 0} {

    if {$dispshear} {
      set cslope 2.0          ;# area,shear sigmoid steepness
      set surfcolor 2         ;# show R/G areal dist
      set normvecflag 1
      set shearvecflag 1
      redraw
      if {$viewlevel > 1} {
        save_rgb_named $rgbname-$hemi-[format "%02d" $i]-areashear.rgb
      }
    }
    if {$dispcurv} {
      set cslope 5.0          ;# curv sigmoid steepness
      set surfcolor 1         ;# show R/G curv
      set normvecflag 0
      set shearvecflag 0
      read_binary_curv        ;# curvature
      redraw
      if {$viewlevel > 1} {
        save_rgb_named $rgbname-$hemi-[format "%02d" $i]-curv.rgb
      }
    }
    if {$dispsulc} {
      set cslope 5.0          ;# curv sigmoid steepness
      set surfcolor 1         ;# show R/G curv
      set normvecflag 0
      set shearvecflag 0
      read_binary_sulc        ;# sulcus
      redraw
      if {$viewlevel > 1} {
        save_rgb_named $rgbname-$hemi-[format "%02d" $i]-sulc.rgb
      }
    }

  }
  if {$savesteps} {
    setfile patch ~/surf/$outpatch-[format "%02d" $step]
    write_binary_patch
  } else {              ;# output is always latest
    setfile patch ~/surf/$outpatch
    write_binary_patch
  }

  incr i
  puts "tksurfer: [file tail $script]: ######## $i of $shrinkcycles ########" 
}

#### save final patch
setfile patch ~/surf/$outpatch
write_binary_patch

if ![info exists noexit] { exit }

