#! /usr/bin/tclsh
##############################################################################
# tksurfer script: real-views [disp two-condition data on 3D folded/unfolded]
##############################################################################
### wrap entire script so script errors/crashes can go to log
catch {

### session dir autoset to $cwd/.. when cwd=scripts (standalone: set here)
#set isession /usr0/fspace/110329MS/image

### tcl-only defs (set for standalone tclscript, order: cmdline,here,readenv)
#set dir scan1           ;# scandir, usu. subdir of "image/" (old: 004/image7)
#set floatstem sig       ;# float wfile stem: <floatstem>-$hemi.w
#set rgbname real        ;# name of rgbfiles

### C-parm defs (set for standalone tclscript, order: cmdline,here,readenv)
#set overlayflag 1       ;# overlay data on gray brain
#set surfcolor 1         ;# draw the curvature under data
#set avgflag 1           ;# make half convex/concave
#set complexvalflag 0    ;# two-component data
#set colscale 1          ;# 0=wheel,1=heat,2=BR,3=BGR,4=twocondGR,5=gray
#set fthresh 0.3         ;# val/curv sigmoid zero (neg=>0)
#set fslope 1.5          ;# contast (was fsquash 2.5)
#set fmid   1.5          ;# set linear region
#set smoothsteps 0
#set offset 0.30         ;# default lighting offset
#set cvfact 1.30         ;# background light/dark curv gray contrast
#set light2 0.8          ;# bakcompat: more top light (old tksurfer def=0.6)

### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(CSURF_DIR)/lib/tcl/readenv.tcl

### check for multiple: floatstem000, floatstem001, ...
set multifloatstemvarlist [lsort [info vars floatstem???]]
if [llength $multifloatstemvarlist] {
  puts "tksurfer: [file tail $script]: found multiple floatstem???"
  set floatstem none  ;# multi resets in foreach loop, pass next test
}

### warn missing req'd scandir/floatstem
foreach var "dir floatstem" {
  if ![info exists $var] {
    puts "\ntksurfer: [file tail $script]: ### variable \"$var\" undefined"
    puts \
    "tksurfer: [file tail $script]: ### set dir (scandir), floatstem (of wfile)"
    puts "\n  cd /usr0/sessions/120101MS/image/scripts"
    puts "  setenv dir 3-stim1                # scandir in \$isession=dir/image"
    puts "  setenv floatstem stim1-vreg+orig  # <floatstem>-rh.w"
    puts "  setenv noexit                     # don't exit after render"
    puts "  setenv nosave                     # don't immediately save bitmap"
    puts "  tksurfer marser rh inflated -tcl [file tail $script]\n"
    exit
  }
}
if ![info exists rgbname] { set rgbname $floatstem }
set complexvalflag 0   ;# force correct
set overlayflag 1      ;# force correct

### default single render
if [info exists floatstem] { set floatstemlist $floatstem }

### setup multiple list: floatstem000, floatstem001, ...
if { [llength $multifloatstemvarlist] } {
  set floatstemlist ""
  foreach var $multifloatstemvarlist { lappend floatstemlist [set $var] }
}

### render, possibly multiple
foreach floatstem $floatstemlist {

  ### force samestem if multiple (render panel rgbname,chkbox ignored)
  if { [llength $floatstemlist] > 1 } { set rgbname $floatstem }

  ### force samestem if single wfile w/multiple option (last,all) selected
  if { [llength $floatstemlist] == 1 && "$rgbname" == "-multiple-" } {
    set rgbname $floatstem
  }

  ### read curvature (or sulc)
  puts "tksurfer: [file tail $script]: read curvature"
  read_binary_curv

  ### optional read t- or F-stat mask (N.B.: single render only!)
  if { [info exists statmaskampflag] && $statmaskampflag && \
       [info exists maskfloatstem] && $maskfloatstem != "" && \
       [llength $floatstemlist] == 1 } {
    puts "tksurfer: [file tail $script]: read, smooth statmask, swap stat/val"
    setfile val */$dir/${maskfloatstem}-$hemi.w
    read_binary_values 
    smooth_val $smoothsteps
    swap_stat_val
    setfile stat $val
  }

  ### read and smooth real data
  puts "tksurfer: [file tail $script]: read and smooth real data"
  if [string match *.mgh $floatstem] {
    setfile val */$dir/${floatstem}
  } else {
    setfile val */$dir/${floatstem}-$hemi.w
  }
  read_binary_values
  smooth_val $smoothsteps

  ### scale and position brain
  puts "tksurfer: [file tail $script]: scale, position brain"
  if ![info exists windowopen] { open_window; set windowopen 1 }

  make_lateral_view       ;# rotate either hemisphere
  do_lighting_model

  ### save requested rgbs
  puts "tksurfer: [file tail $script]: save rgb's"
  source $env(CSURF_DIR)/lib/tcl/saveviews.tcl

}

### errors (if any) to log
} ret
if {$ret != ""} { puts "tksurfer: [file tail $script]: ### $ret" }

if ![info exists noexit] { exit }
