#! /usr/bin/tclsh
#############################################################################
# saveviews.tcl: sourced by views scripts [save view subset, min redraw lat]
##############################################################################

### export/setenv any subset of: {lat,med,ven,pos,dor,all or custom<transform>}
### xform order: lat => xrot => yrot => zrot => xtrans => ytrans => scale
### {dont}save_rgb_named do "setfile rgb $arg" to update surfer tools

### defaults
set imsuff rgb
if [info exists tiffoutflag] {
  if {$tiffoutflag} { set imsuff tiff }
}

### show lat even when nothing set
if { ![info exists lat] && ![info exists med] && ![info exists ven] && \
     ![info exists dor] && ![info exists pos] && ![info exists all] && \
     [info vars custom*] == "" } {
  set lat 1
}

### be nice
if { [info exists nosave] } {
  puts "saveviews.tcl: nosave setenv'd => nothing will be saved"
}
if { [info exists phasemovie] } {
  puts "saveviews.tcl: phasemovie setenv'd => no single rgbs"
}

### save lateral view
if { [info exists lat] || [info exists all] } {
  make_lateral_view
  if { [info exists viewsscale] } { scale_brain $viewsscale }
  raise_window
  redraw
  if { ![info exists nosave] && ![info exists phasemovie] } {
    save_rgb_named $rgbname-$hemi-$surfext-lat.$imsuff
  } else {
    dontsave_rgb_named $rgbname-$hemi-$surfext-lat.$imsuff
  }
}

### save medial view
if { [info exists med] || [info exists all] } {
  make_lateral_view
  rotate_brain_y 180
  if [info exists viewsscale] { scale_brain $viewsscale }
  raise_window
  redraw
  if { ![info exists nosave] && ![info exists phasemovie] } {
    save_rgb_named $rgbname-$hemi-$surfext-med.$imsuff
  } else {
    dontsave_rgb_named $rgbname-$hemi-$surfext-med.$imsuff
  }
}

### save ventral view
if { [info exists ven] || [info exists all] } {
  make_lateral_view
  rotate_brain_x 90
  if [info exists viewsscale] { scale_brain $viewsscale }
  raise_window
  redraw
  if { ![info exists nosave] && ![info exists phasemovie] } {
    save_rgb_named $rgbname-$hemi-$surfext-ven.$imsuff
  } else {
    dontsave_rgb_named $rgbname-$hemi-$surfext-ven.$imsuff
  }
}

### save dorsal view
if { [info exists dor] || [info exists all] } {
  make_lateral_view
  rotate_brain_x -90
  if [info exists viewsscale] { scale_brain $viewsscale }
  raise_window
  redraw
  if { ![info exists nosave] && ![info exists phasemovie] } {
    save_rgb_named $rgbname-$hemi-$surfext-dor.$imsuff
  } else {
    dontsave_rgb_named $rgbname-$hemi-$surfext-dor.$imsuff
  }
}

### save posterior view
if { [info exists pos] || [info exists all] } {
  make_lateral_view
  if {$hemi == "lh"} {
    rotate_brain_y 90
  } elseif {$hemi == "rh"} {
    rotate_brain_y -90
  }
  raise_window
  redraw
  if [info exists viewsscale] { scale_brain $viewsscale }
  if { ![info exists nosave] && ![info exists phasemovie] } {
    save_rgb_named $rgbname-$hemi-$surfext-pos.$imsuff
  } else {
    dontsave_rgb_named $rgbname-$hemi-$surfext-pos.$imsuff
  }
}

### save custom view if any custom transforms
if { [info exists customxrot] || \
     [info exists customyrot] || \
     [info exists customzrot] || \
     [info exists customxtrans] || \
     [info exists customytrans] || \
     [info exists customscalepercent] } {
  make_lateral_view
  if { [info exists customxrot] } { rotate_brain_x $customxrot }
  if { [info exists customyrot] } { rotate_brain_y $customyrot }
  if { [info exists customzrot] } { rotate_brain_z $customzrot }
  if { [info exists customxtrans] } { translate_brain_x $customxtrans }
  if { [info exists customytrans] } { translate_brain_y $customytrans }
  if { [info exists customscalepercent] } {
    scale_brain [expr $customscalepercent/100.0]
  }
  raise_window
  redraw
  if { ![info exists nosave] && ![info exists phasemovie] } {
    save_rgb_named $rgbname-$hemi-$surfext-cus.$imsuff
  } else {
    dontsave_rgb_named $rgbname-$hemi-$surfext-cus.$imsuff
  }
}

