################################################
# stripairPD.tcl: for tkstrip: for PD from qT1
################################################
### tkstrip marser <whatever>.mgz -tcl stripairPD.tcl

### wrap entire script so errs go to log
catch {

### in/out surf (@ = abbrev for $CSURF_DIR/lib/bem)
setfile insurf @/ic5.tri    ;# higher res than default ic4
setfile outsurf ~/surf/skinPD.tri

### mask/in/out 3D MRI (mgz) (~ is abbrev for $SUBJECTS_DIR/<currsubj>
setfile maskim ~/mri/pd.mgz    ;# setfile is a globbing 'set'
setfile inim ~/mri/orig.mgz
setfile outim ~/mri/orig2.mgz

### report (N.B.: script overrides commandline imageset)
if ![okreplace "" "OK to Strip Air from from 3D data set?\
                 \n(N.B.: files defined in script, cmdline file ignored)\
               \n\ninput1 (shrink onto this dataset):\n    $maskim\
               \n\ninput2 (mask this dataset):\n    $inim\
               \n\noutput file:\n    $outim" "Remove Air"] {
  return
}
if ![okreplace $outim] { return }

### init parms (rarely adjust these)
set shrinkmode 4    ;# samp:1=inout,3=out,4=pnt
set dfrac 1.4       ;# shrink from outside
set istilt 0.0      ;# intern stilt (0=surf)
set fsteepness 100  ;# slope force tanh
set update 0.1
set decay 0.1
set flattenflag 0   ;# do at end
set momentumflag 1

### fzero: low->plump (outforce->0 below, 60% GM)
set fzero 40.0      ;# PDe1: -p 4.5, qPD: -p 0.8

### normal force weight (vs. preserve surf geom weight)
set fstrength 0.05  ;# or 0.1, w/less steps

### fmax: inforce->0 below (shrinkmode=1 only!)
#set fmax 255

### read surface/3D data, openwin
read_geometry
read_images
init_surf_to_image   ;# uses dfrac
open_window
rotate_brain_x 90
rotate_brain_y 90
redraw

### slow shrink
set initreps 250    ;# or 200 reps w/fstrength=0.1
for {set i 0} {$i < $initreps} {incr i} {
  shrink 50         ;# less tcl, much faster
  redraw
}

### turn up MRI force at end (flatten)
set flattenflag 1
set fstrength 0.5
set flattenreps 100  ;# (10) higher OK no eye bubble
for {set i 0} {$i < $flattenreps} {incr i} {
  shrink 10
  redraw
}

### final touch-up relax surface
set MRIflag 0
set momentumflag 0
for {set i 0} {$i < 2} {incr i} {
  shrink 1
  redraw
}

### save stripped PD surface
raise .
raise_window
write_geometry

### strip orig.mgz imageset, write output
set $inim $maskim
read_images
peel_brain
write_images
confirmalert "Output dataset written:\n\n    $outim"

### errors (if any) to log
} ret
if {$ret != "" && $ret != 0} { puts "tkstrip: [file tail $script]: ### $ret" }

