#! /usr/bin/tclsh
##############################################################################
# tksurfer script: fs-make    [calc,write fieldsign using patch]
##############################################################################
### wrap entire script so script errors/crashes can go to log
catch {

### session dir autoset to $cwd/.. when cwd=scripts (standalone: set here)
#set isession /usr0/fspace/110329MS/image

### tcl-only defs (set for standalone tclscript, order: cmdline,here,readenv)
#set dir fs              ;# current trimoneparent scandir (*no* "image")
#set floatstem sig       ;# float file stem (eccen/polarstem overrides)
#set eccendir eccen      ;# eccen dir
#set polardir polar      ;# polar dir
#set realname _r         ;# real infix in wfile
#set complexname _i      ;# imaginary infix in wfile
#set patchname occip.patch.flat   ;# appended to $hemi.

### C-parm defs (set for standalone tclscript, order: cmdline,here,readenv)
#set smoothsteps 50

### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(CSURF_DIR)/lib/tcl/readenv.tcl

### read curvature (or sulc)
puts "tksurfer: [file tail $script]: read curvature"
read_binary_curv

### fieldsign functions compute junk without patch
setfile patch ~/surf/$hemi.$patchname
if ![file exists $patch] {
 puts "tksurfer: [file tail $script]: ### can't compute fieldsign without patch"
 puts "tksurfer: [file tail $script]: ####### compute fieldsign failed ########"
 exit
}
if ![info exists eccenstem] { set eccenstem $floatstem }
if ![info exists polarstem] { set polarstem $floatstem }

#### ECCENTRICITY ####
### read and smooth imag component MRI Fourier transform of *eccen* data
puts "tksurfer: [file tail $script]: read, smooth complex Fourier comp: eccen"
setfile val */$eccendir/${eccenstem}${complexname}-$hemi.w
read_binary_values
smooth_val $smoothsteps
#shift_values              ;# old name, still works
copy_val_val2              ;# shift imag component out of way

### read and smooth real component MRI Fourier transform of *eccen* data
puts "tksurfer: [file tail $script]: read, smooth real Fourier comp: eccen"
setfile val */$eccendir/${eccenstem}${realname}-$hemi.w
read_binary_values
smooth_val $smoothsteps
#swap_values               ;# old name, still works
swap_valval2_valbakval2bak ;# swap both components eccentricity out of way

#### POLAR ANGLE ####
### read and smooth imag component MRI Fourier transform of *theta* data
puts "tksurfer: [file tail $script]: read, smooth complex Fourier comp: polar"
setfile val */$polardir/${polarstem}${complexname}-$hemi.w
read_binary_values
smooth_val $smoothsteps
#shift_values              ;# old name, still works
copy_val_val2              ;# shift imag component out of way

### read and smooth real component MRI Fourier transform of *theta* data
puts "tksurfer: [file tail $script]: read, smooth real Fourier comp: polar"
setfile val */$polardir/${polarstem}${realname}-$hemi.w
read_binary_values
smooth_val $smoothsteps
#swap_values                ;# old name, still works
swap_valval2_valbakval2bak  ;# swap again (r,th)

### read 2D patch; calc fieldsign and mask
puts "tksurfer: [file tail $script]: read patch"
read_binary_patch
puts "tksurfer: [file tail $script]: x-y to polar"
compute_angles          ;# real/complex => ampl/phase
puts "tksurfer: [file tail $script]: compute fieldsign"
compute_fieldsign       ;# gradients, cross prod, scale by geom mean r,th pow

### write fieldsign and mask, original fs-unique format and filename
puts "tksurfer: [file tail $script]: write fieldsign"
setfile fs */$dir/$hemi.fs
write_fieldsign         ;# -1,0,1 => now actual gradients crossprodamp (~0.002)
puts "tksurfer: [file tail $script]: write fieldsign mask"
setfile fm */$dir/$hemi.fm
write_fsmask            ;# thresh, now depends on eccen *and* polar angle

### write fieldsign and mask, curv format with wfile name (2014)
puts "tksurfer: [file tail $script]: write fieldsign in curvfile format"
setfile fs */$dir/fs-$hemi.w
write_fieldsign_curvfmt
puts "tksurfer: [file tail $script]: write fieldsign mask in curvfile format"
setfile fm */$dir/fm-$hemi.w
write_fsmask_curvfmt

### errors (if any) to log
} ret
if {$ret != ""} { puts "tksurfer: [file tail $script]: ### $ret" }

if ![info exists noexit] { exit }

