######################################################################
# calcoverlap.tcl: calc overlap between set of labels and HCP regions
######################################################################
### to use this tcl script in csurf tksurfer:
#  (1) copy this script into an (editable!) subject's scripts dir
#  (2) adjust parameters to fit you situation
#  (3) open subject hemisphere (SURFACE button)
#  (4) find script in "tcl:" dropdown (or type in arbitrary path)
#  (5) click GO
# N.B.: uses live tksurfer tcl vars: $env, $hemi, $subject
# N.B.: works on fsaverage if subject fsaverage is editable

# parameters (change as needed)
set outdir /tmp
set myregiondir /usr0/raw/191101BC-ICA_mgh
set myregionlist_lh {
  ICA3_higherordervisual_lh_1.mgh
  ICA3_higherordervisual_lh_2.mgh
  ICA4_lateralvisual_lh.mgh
  ICA5_auditory_lh.mgh
  ICA9_medialvisual_lh.mgh
  ICA15_occipvisual_lh.mgh
  ICA16_motor_lh.mgh
  ICA19_lateral_sensorimotor_lh.mgh
  ICA20_medial_sensorimotor_lh.mgh
}
set myregionlist_rh {
  ICA3_higherordervisual_rh_1.mgh
  ICA3_higherordervisual_rh_2.mgh
  ICA4_lateralvisual_rh.mgh
  ICA5_auditory_rh.mgh
  ICA9_medialvisual_rh.mgh
  ICA15_occipvisual_rh.mgh
  ICA16_motor_rh.mgh
  ICA19_lateral_sensorimotor_rh.mgh
  ICA20_medial_sensorimotor_rh.mgh
}

# detect hemi to get correct myregion list
if {$hemi == "lh"} { set regionlist $myregionlist_lh }
if {$hemi == "rh"} { set regionlist $myregionlist_rh }

# read and display MGH HCP annotation regions
clear_annot
setfile anlabel ~/label/$hemi.HCP-MMP1.annot
read_mgh_annot
set_annot_alpha 128
set labelflag 1
redraw

# foreach myregion, load it, calc overlap w/MGH regions, move/rename outfile
foreach myregion $regionlist {
  clear_values
  setfile val $myregiondir/$myregion
  read_binary_values
  set colscale 11
  set overlayflag 1  ;# so we can see regions as loaded
  redraw
  calc_annots_nzval_overlap
  set outfile $env(SUBJECTS_DIR)/$subject/scripts/$hemi.overlap.txt
  set newoutfile $outdir/$hemi.overlap.[file rootname $myregion].txt
  exec mv $outfile $newoutfile
}

