###################################################################
# renderoffscreen.tcl: mk hi-res tiff w/rainbow-like contour lines
###################################################################
# HOWTO run this script:
#
#   fs      # alias to setup csurf paths
#   cd /usr0/fspace/140408XS-polletdilima17/image/scripts
#   cp $CSURF_DIR/lib/tcl/zz-examples/renderoffscreen.tcl .
#   tksurfer fsaverage lh inflated_avg -tcl renderoffscreen.tcl
#

### b/c close_window crashes w/offscreen window so can't restore direct-render
if {$openglwindowflag} { 
  if [okreplace "" \
        "Off-screen render requires closing current window\n\nOK to proceed?" \
        "Off-Screen Render"] {
    close_window
  } else {
    return
  }
}

### render offscreen for larger than display
set renderoffscreen 1
resize_window 2500    ;# 4200 works
open_window

### set pose
read_binary_curv
make_lateral_view
scale_brain 1.07

### set scandirs/fileprefix
set scandir 140111polletdilima
set wfileprefix 140111polletdilima

### read/smooth overlay stats/complex data
setfile val */$scandir/${wfileprefix}-stat-sph-sm1_g-$hemi.w
read_binary_values
smooth_val 10
swap_stat_val
setfile val */$scandir/${wfileprefix}-mean-sph-sm1_y-$hemi.w
read_binary_values
smooth_val 10
copy_val_val2
setfile val */$scandir/${wfileprefix}-mean-sph-sm1_x-$hemi.w
read_binary_values
smooth_val 10
set statmaskampflag 1

### set render parms
set colscale 8
set overlayflag 1
set revphaseflag 1
set fslope 0.03
set sfslope 1.0
set fmid 50
set sfmid 1.0
set angle_cycles 62
set angle_offset 0.501

### save bitmap
redraw
set rgb /tmp/cover.tiff
save_rgb
exit

