#! /usr/bin/tclsh
##############################################################################
# surfer script: twocond-views [disp two-condition data on 3D folded/unfolded]
##############################################################################
### wrap entire script so script errors/crashes can go to log
catch {

### session dir autoset to $cwd/.. when cwd=scripts (standalone: set here)
#set isession /usr0/fspace/110329MS/image

### tcl-only defs (set for standalone tclscript, order: cmdline,here,readenv)
#set dir twocond         ;# scandir, usu. subdir of "image/" (old: 004/image7)
#set rgbname twocond     ;# name of rgbfiles
#set floatstem sig       ;# wfile stem
#set realname _r         ;# real infix in wfile
#set complexname _i      ;# imaginary infix in wfile
#set cplxstatname none   ;# on of the following 3
### vars definitions from csurf, not used here
#set cplxstatname1 _f    ;# infix cross-subj F-ratio from complex raw amp
#set cplxstatname2 _g    ;# infix cross-subj F-ratio from complex sig
#set cplxstatname3 _a    ;# infix cross-subj t-test of complex sig vs. num
#set cplxstatname4 _e    ;# infix cross-subj Rayleigh test cpx sig vs. num
#set cplxstatname5 _b    ;# infix cross-subj t-test of complex pow vs. num
#set cplxstatname6 _h    ;# infix cross-subj cluster-filtered F-ratio

### C-parm defs (set for standalone tclscript, order: cmdline,here,readenv)
#set overlayflag 1       ;# overlay data on gray brain
#set surfcolor 1         ;# draw the curvature under data
#set avgflag 1           ;# make half convex/concave
#set complexvalflag 1    ;# two-component data
#set colscale 4          ;# 0=wheel,1=heat,2=BR,3=BGR,4=twocondGR,5=gray
#set fthresh 0.3         ;# val/curv sigmoid zero (neg=>0)
#set fslope 1.5          ;# contast (was fsquash 2.5)
#set fmid   1.5          ;# set linear region
#set smoothsteps 10
#set statflag 0          ;# default Fourier (no F stats)
#set offset 0.30         ;# default lighting offset
#set cvfact 1.30         ;# background light/dark curv gray contrast
#set light2 0.8          ;# bakcompat: more top light (old tksurfer def=0.6)

### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(CSURF_DIR)/lib/tcl/readenv.tcl

### default missing tcl-only for standalone, except req'd scandir/floatstem
if ![info exists realname]      { set realname _r } 
if ![info exists complexname]   { set complexname _i }
if ![info exists cplxstatname]  { set cplxstatname none }
foreach var "dir floatstem" {
  if ![info exists $var] {
    puts "\ntksurfer: [file tail $script]: ### variable \"$var\" undefined"
    puts \
    "tksurfer: [file tail $script]: ### set dir (scandir), floatstem (of wfile)"
    puts "\n  cd /usr0/sessions/120101MS/image/scripts"
    puts "  setenv dir 3-stim1                # scandir in \$isession=dir/image"
    puts "  setenv floatstem stim1-vreg+orig  # <floatstem>_r-rh.w"
    puts "  setenv noexit                     # don't exit after render"
    puts "  setenv nosave                     # don't immediately save bitmap"
    puts "  tksurfer marser rh inflated -tcl [file tail $script]\n"
    exit 
  } 
} 
if ![info exists rgbname] { set rgbname $floatstem }
set complexvalflag 1   ;# force correct 
set overlayflag 1      ;# force correct

### read curvature (or sulc)
puts "tksurfer: [file tail $script]: read curvature"
read_binary_curv

### old Fourier-derived F-stats (was if statflag, tksurfer vars now removed)
#set statname f           ;# deprecated F stats (default: statflag=0: Fourier)
#set statflag 0           ;# default: Fourier
#
#puts "tksurfer: [file tail $script]: read and smooth F-stats"
#setfile val */$dir/${floatstem}${statname}-$hemi.w
#read_binary_values
#smooth_val $smoothsteps
#swap_stat_val
#set complexvalflag 1  ;# csurf !complex sets statflag->readstats, view->reset

### opt off/repl/mask/mult amp by none/cxFamp(_f)/cxFsig(_g)/tsig(_a)(12combos)
set readstat 0
if { [info exists statmultampflag] && $statmultampflag } { set readstat 1 }
if { [info exists statmaskampflag] && $statmaskampflag } { set readstat 2 }
if { [info exists statreplampflag] && $statreplampflag } { set readstat 3 }
if {$readstat} {
  puts "tksurfer: [file tail $script]: read and smooth stat mask"
  if {$readstat == 1} {puts "tksurfer: [file tail $script]: stat multiply amp"}
  if {$readstat == 2} {puts "tksurfer: [file tail $script]: stat masks amp"}
  if {$readstat == 3} {puts "tksurfer: [file tail $script]: stat replaces amp"}
  set i [string first -mean- $floatstem] ;# csurf xsubjavg: -mean- => -{t}stat-
  if {$i != -1} {
    set newinfix stat ;#N.B.: match csurf literal
    if {$cplxstatname == "_a"} {set newinfix tstat} ;#N.B.: match csurf literal
    if {$cplxstatname == "_b"} {set newinfix tstat} ;#N.B.: match csurf literal
    puts "tksurfer: [file tail $script]: $floatstem: -mean- infix => $newinfix"
    set statfloatstem [string range \
      $floatstem 0 $i]${newinfix}[string range $floatstem [expr $i + 5] end]
    setfile val */$dir/${statfloatstem}${cplxstatname}-$hemi.w
  } else {
    puts "tksurfer: [file tail $script]: no \"-mean-\" infix in $floatstem"
    setfile val */$dir/${floatstem}${cplxstatname}-$hemi.w
  }
  # if $maskfloatstem exists (passed to tcl via env) use it (overrides above!)
  if { [info exists maskfloatstem] &&
       $maskfloatstem != "" && $maskfloatstem != "-unset-"} {
    puts "tksurfer: [file tail $script]: \$maskfloatstem exists, override above"
    setfile val */$dir/${maskfloatstem}-$hemi.w  ;# stem includes cplxstatname
  }
  puts "tksurfer: [file tail $script]: read stats, swap_stat_val"
  read_binary_values
  smooth_val $smoothstepsstat
  swap_stat_val
  setfile stat $val
}

### read and smooth complex-valued F-stat (r=sqrt(F), theta=phase)
if { [info exists cpxangrealampflag] && $cpxangrealampflag} {
  ## read real/imag, avg cmplx ang, avg neigh amp ignoring phase dispersion
  puts "tksurfer: [file tail $script]: read imag Fourier comp, mv to val2"
  setfile val */$dir/${floatstem}${complexname}-$hemi.w     ;# two cond data
  read_binary_values
  copy_val_val2
  puts "tksurfer: [file tail $script]: read real Fourier comp"
  setfile val */$dir/${floatstem}${realname}-$hemi.w
  read_binary_values
  puts "tksurfer: [file tail $script]: smooth ignore dispers.: avg ang/realamp"
  smooth_complexang_realamp $smoothsteps
} else {  ;# standard complex vector avg
  ## read and smooth imag component MRI Fourier transform of data
  puts "tksurfer: [file tail $script]: read and smooth complex Fourier comp"
  setfile val */$dir/${floatstem}${complexname}-$hemi.w     ;# two cond data
  read_binary_values
  smooth_val $smoothsteps
  copy_val_val2
  ## read and smooth real component MRI Fourier transform of data
  puts "tksurfer: [file tail $script]: read and smooth real Fourier comp"
  setfile val */$dir/${floatstem}${realname}-$hemi.w
  read_binary_values
  smooth_val $smoothsteps
}

### scale and position brain
puts "tksurfer: [file tail $script]: scale, position brain"
open_window
make_lateral_view       ;# rotate either hemisphere
do_lighting_model

### save requested rgbs
puts "tksurfer: [file tail $script]: save rgb's"
source $env(CSURF_DIR)/lib/tcl/saveviews.tcl

### save phasemovie
if [info exists phasemovie] {
  puts "tksurfer: [file tail $script]: save phasemovie"
  source $env(CSURF_DIR)/lib/tcl/phasemovie.tcl
}

### errors (if any) to log
} ret
if {$ret != ""} { puts "tksurfer: [file tail $script]: ### $ret" }

if ![info exists noexit] { exit }

