################################################
# skullstripPD.tcl: for tkstrip: for PD from qT1
################################################
### tkstrip marser PD.mgz -tcl stripskullPD.tcl

### wrap entire script so errs go to log
catch {

### in/out surf
#setfile insurf @/ic4.tri
setfile insurf @/ic5.tri   ;# higher res
setfile outsurf ~/surf/brainPD.tri

### in/out MRI (mgz)
setfile inim  ~/mri/PD.mgz
setfile outim ~/mri/PDbrain.mgz
## HOWTO use CORdir's instead
#setfile inim  ~/mri/PD
#setfile outim ~/mri/PDbrain

### report script overriding commandline
puts "skullstripPD.tcl:"
puts "  inp: $inim"
puts "  out: $outim"

### init parms (rarely adjust these)
set shrinkmode 4    ;# samp:1=inout,3=out,4=pnt
set dfrac 0.3       ;# starting surf size
#set dfrac 1.5      ;# HOWTO shrink from outside
set istilt 0.0      ;# intern stilt (0=surf)
set fsteepness 100  ;# slope force tanh
set update 0.1
set decay 0.1
set flattenflag 0
set momentumflag 1

### fzero: low->plump (outforce->0 below, 60% GM)
set fzero 65.0      ;# PDe1: -p 4.5, qPD: -p 0.8

### force weight (vs. preserve surf geom weight)
set fstrength 0.05  ;# or 0.1, w/less steps

### fmax: inforce->0 below (shrinkmode=1 only!)
set fmax 130 

### read data, openwin
read_geometry
read_images
init_surf_to_image
open_window
rotate_brain_x 90
rotate_brain_y 90
redraw

### slow shrink -- don't overshoot thin dark rim
set initreps 350    ;# or 200 reps w/fstrength=0.1
for {set i 0} {$i < $initreps} {incr i} {
  shrink 50         ;# less tcl, much faster
  redraw
}

### turn up MRI force at end (flatten)
set flattenflag 1
set fstrength 0.5
set flattenreps 100  ;# (10) higher OK no eye bubble
for {set i 0} {$i < $flattenreps} {incr i} {
  shrink 10
  redraw
}

### touch-up relax
set MRIflag 0
for {set i 0} {$i < 2} {incr i} {
  shrink 1
  redraw
}

### vertex normal inward move to mask CSF
move_vertices -1.0
redraw

### save stripped PD
raise .
raise_window
write_geometry
peel_brain
write_images

### mask "orig" w/stripped PD ("PDbrain") to mk "brain"
setfile inim   ~/mri/orig.mgz
setfile maskim ~/mri/PDbrain.mgz
setfile outim  ~/mri/brain.mgz
puts [eval exec calcimg -oper 1 $inim $maskim $outim]

### errors (if any) to log
} ret
if {$ret != ""} { puts "tkstrip: [file tail $script]: ### $ret" }

