#! /usr/bin/tclsh
#############################################################################
# tksurfer script: slices.tcl  [save slice img sets 3 planes around curr curs]
##############################################################################
### N.B.: for pulvinar illus
### N.B.: caller must init $userok to 0 (uses current cursor)

### defaults
set slices 20
set prefix $rgb
if [string match *-cor.tiff $rgb] {
  set prefix [string range $rgb 0 [expr [string length $rgb] - 10]]
}
if [string match *-tkm-sag-???.tiff $rgb] { ;# in case re-run
  set prefix [string range $rgb 0 [expr [string length $rgb] - 18]]
}
set nocursorflagSAV $nocursorflag
set nocursorflag 1
set bigcursorflagSAV $bigcursorflag
set bigcursorflag 1
set coronal_flag 1
set horizontal_flag 1
set sagittal_flag 1

### two ways to override defaults
if [winfo viewable .] {    ;# make popup
  if {!$userok} {
    controls "SAVE TKMEDIT SLICES (in 3 planes around cursor)" { \
      prefix slices whitespace nocursorflag bigcursorflag whitespace \
      coronal_flag horizontal_flag sagittal_flag } \
      "RUN SCRIPT" "set userok 1; source [info script]" 45
    return
  }
} else {                   ;# batch scripts; re-read env to override defaults
  source $env(CSURF_DIR)/lib/tcl/readenv.tcl
}

### save slices around click
set planelist ""
if {$coronal_flag}    { lappend planelist cor }
if {$horizontal_flag} { lappend planelist hor }
if {$sagittal_flag}   { lappend planelist sag }
foreach planetype $planelist {
  set plane [set $planetype]   ;# get value of tkmedit.tcl plane enums
  for {set i 0} {$i < [expr $slices/2] } {incr i} {
    downslice
    redraw
  }
  for {set i 0} {$i < $slices} {incr i} {
    upslice
    redraw
    setfile rgb $prefix-tkm-$planetype-[format "%03d" $i].tiff
    save_rgb
  }
  for {set i 0} {$i < [expr $slices/2] } {incr i} {
    downslice
    redraw
  }
}
set nocursorflag $nocursorflagSAV
set bigcursorflag $bigcursorflagSAV
redraw
