#! /usr/bin/tclsh
#############################################################################
# tksurfer script: setdefpatchview (called by flat scripts, tksurfer restore)
#############################################################################

### before readenv (just chk for patchname; don't blow away aliased patchname)
if ![info exists patchname] {
  if { ![info exists aliasedscript] } { set patchname patch } ;# default
  foreach var [array names env] {
    if { $var == "patchname" } { set patchname $env($var) }
    if { $var == "nomidzrot" } { set nomidzrot $env($var) } 
    if { $var == "nomidscale" } { set nomidscale $env($var) } 
  }
}
if ![info exists patchname] {
  puts "setdefpatchview: ### \$patchname (tcl var) not defined  ...skipping"
  return
}

### source position.tcl from *subjectsdir* if there 
if { [file exists $env(SUBJECTS_DIR)/$subject/scripts/position.tcl] } {
  puts "setdefpatchview: ==> read default patchview from position.tcl"
  source $env(SUBJECTS_DIR)/$subject/scripts/position.tcl
} else {
  puts "setdefpatchview: ### position.tcl for $subject does not exist"
  puts "setdefpatchview: ### setting flatzrot to 90 (default)"
  set flatzrot 90
  puts "setdefpatchview: ### setting flatscale to 1.0 (default)"
  set flatscale 1.0
  puts "setdefpatchview: ### setting flatxtrans to 0.0 (default)"
  set flatxtrans 1.0
  puts "setdefpatchview: ### setting flatytrans to 0.0 (default)"
  set flatytrans 1.0
  return
} 

### also set transform vars if patchname matches std pattern w/typesuff
set tmppatchname $patchname
foreach type { full occip } {   ;# add others
  foreach suff { flat } {  ;# don't do *.3d, since we usu. want viewcuts-like
    set stdflatpatchname $type.patch.flat
    if { $patchname != $stdflatpatchname && \
         [string match ${type}*.patch.${suff}* $patchname] } {
      set tmppatchname $stdflatpatchname
    }
  }
}

### make "cortex*" (fsaverage) synonym of "full"
if { [string match cortex*.patch.flat $patchname] } {
  set tmppatchname full.patch.flat
}

### make "occ*" (e.g., occsm) synonym of "occip"
if { [string match occ*.patch.flat $patchname] } {
  set tmppatchname occip.patch.flat
}

### set rot/trans/scale vars for this hemi/patch combo
foreach possuff { flatzrot flatscale flatxtrans flatytrans } {
  if { [info exists $hemi.$tmppatchname.$possuff] } { ;# position.tcl sourced
    set $possuff [set $hemi.$tmppatchname.$possuff]
    puts "setdefpatchview: set $possuff [set $possuff]"
  } else {
    puts \
     "setdefpatchview: ### $hemi.$tmppatchname.$possuff not set in position.tcl"
    if { $possuff == "flatzrot" }   { set $possuff 0   }
    if { $possuff == "flatscale" }  { set $possuff 1.0 }
    if { $possuff == "flatxtrans" } { set $possuff 0.0 }
    if { $possuff == "flatytrans" } { set $possuff 0.0 }
    puts "setdefpatchview: ### set $possuff [set $possuff] (default)"
  }
}
