#! /usr/bin/tclsh
###########################################################################
# read names/values of non-cap setenv vars to override default parms
# in csh scripts:
#   global:     setenv parm value
#   singlerun:  setenv $rgbname.parm value
# NOTE:
#   (old) setenv (but not set!) can set varname longer than 20char csh limit
#   (old) tcl (but not csh!) can read such over-20-char-long env vars
#   set,setenv (but not tcl set!) create empty var w/o arg (tcl returns err!)
# 151014: MacOSX 10.11 workaround
#   read file because MacOSX 10.11 doesn't pass PATH,DYLD to subshell (for env)
#   tclenv file written by csurf immediately before calling following:
#     tksurfercmd, surftestrender{nopanel}, fieldsigncmd, findretinborderscmd
#   even tho env passes non-PATH,DYLD OK, can't use env at all b/c of above
#   csurftclenv format is like bash: var=value
###########################################################################

### first read lower-case global env vars
puts "readenv.tcl: ==> read global setenv vars"
foreach var [array names env] {
  if { [string range $var 0 0] >= "a" } {
    set root [file root $var]
    set extension [string trimleft [file extension $var] .]
    if { [string length $extension] == 0 } {    # no extension: global
      set $var $env($var)
      puts "readenv:  set $var $env($var)"
    }
  }
}

### then read lower-case rgbname-specific env vars (overwrite global)
if [info exists rgbname] {
  puts "readenv.tcl: ==> read rgbname-specific setenv vars"
  foreach var [array names env] {
    if { [string range $var 0 0] >= "a" } {
     set root [file root $var]
      set extension [string trimleft [file extension $var] .]
      if { [string length $extension] > 0 } {           # if there is ext
        if { [string compare $rgbname $root] == 0 } {   # if correct root
          set $extension $env($var)
          puts "readenv:  set $extension $env($var)"
        }
      }
    }
  }
}

### csurf can't use above w/MacOSX10.11 b/c can't start w/"env parm=val prog.."
if [info exists csurftclenv] {
  if {$csurftclenv != ""} {
    if [file exists $csurftclenv] {
      if ![catch { open $csurftclenv r } ret] {
        puts \
 "readenv.tcl: ==> set tcl vars from \$csurftclenv=$csurftclenv (overrides env)"
        set id $ret
        foreach line [split [read $id] \n] {
          if {$line == ""} { continue }
          if [string match "#*" $line] { continue }
          set eq [string first = $line]
          if {$eq == -1} { continue }
          set var [string range $line 0 [expr $eq - 1]]
          set valu [string range $line [expr $eq + 1] end]
          set $var "$valu"
          puts "readenv.tcl:  set $var $valu"
        }
        close $id
      }
      if [info exists var] { unset var }
      if [info exists valu] { unset valu }
      if [info exists eq] { unset eq }
    } else { puts "readenv.tcl: ==> file $csurftclenv not found" }
  } else { puts "readenv.tcl: ==> \$csurftclenv is empty string" }
} else { puts "readenv.tcl: ==> \$csurftclenv not defined" }

prompt

