#! /usr/bin/tclsh
#############################################################################
# surfer script: curv-flat  [display curvature on flat]
##############################################################################
### wrap entire script so script errors/crashes can go to log
catch {

### tcl-only defs
set rgbname curv        ;# curv,sulc -- rgbfile name + sets display type
set patchname occip.patch.flat   ;# appended to $hemi.
set flatzrot 0          ;# patch rotate
set flatscale 1.0       ;# patch scale

### C-parm defs
set overlayflag 0       ;# overlay data on gray brain
set surfcolor 1         ;# draw the curvature under data
set avgflag 1           ;# make half convex/concave
set cslope 5.0          ;# curv sigmoid steepness
set offset 0.30         ;# default lighting offset
set cvfact 1.30         ;# background light/dark curv gray contrast
set light2 0.8          ;# bakcompat: more top light (old tksurfer def=0.6)

### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(CSURF_DIR)/lib/tcl/readenv.tcl

### read default patch view if there (after env to use patchname)
source $env(CSURF_DIR)/lib/tcl/setdefpatchview.tcl

### read curvature (or sulc)
puts "tksurfer: [file tail $script]: read curvature"
if { $rgbname == "curv" } {
  read_binary_curv
} elseif { $rgbname == "sulc"} {
  read_binary_sulc
} else {
  puts "### tksurfer: [file tail $script]: $rgbname: bad coloring type"
  exit
}

### read 2D patch; calc,write fieldsign and mask
puts "tksurfer: [file tail $script]: read patch"
setfile patch ~/surf/$hemi.$patchname
read_binary_patch       ;# overwrites initial surface read in

### initial scale and position patch
puts "tksurfer: [file tail $script]: scale, position brain"
open_window
restore_zero_position   ;# undo initial centering
do_lighting_model
rotate_brain_x -90

### save requested rgbs (transforms done here)
puts "tksurfer: [file tail $script]: save rgb's"
source $env(CSURF_DIR)/lib/tcl/saveflat.tcl

### errors (if any) to log
} ret
if {$ret != ""} { puts "tksurfer: [file tail $script]: ### $ret" }

if ![info exists noexit] { exit }

