#! /bin/csh -f

### onearch: find my generic architecture (onearch)
#Linux: uname -m=i686/x86_64            -i=i386/x86_64 -p=i386/i686/x86_64/unk
#Mac:   uname -m=i386/"Power Macintosh" -i=[illegal]   -p=i386/powerpc
#IRIX:  uname -m=IP22/IP30              -i=[illegal ]  -p=mips/...

### hacks
set fixldcycle = 0    # only needed Darwin 10.5 (9.* kernels)

### get uname info
#set hdrw = `uname -i` # Linux: i386/x86_64, Mac/IRIX: illegal option
set syst = `uname -s` # Darwin, Linux, IRIX, IRIX64
set proc = `uname -p` # powerpc, i386, i686, athlon, x86_64, mips, Ubun->unknown
set rele = `uname -r` # e.g., Darwin=8.11.0, Linux=2.6.23.17-88.fc7, IRIX=6.5
set mach = `uname -m` # Power Macintosh, i686, IP30, x86_64

### my classify
set known = ( Darwin-ppc Darwin-i386 Darwin-x86_64 \
              Linux-i386 Linux-x86_64 \
              IRIX-mips IRIX64-mips )
set onearch = unknown
if ($syst == "Darwin" && $proc == "powerpc") then
  set onesyst = Darwin
  set oneproc = ppc
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Darwin" && $proc == "i386") then
  set onesyst = Darwin
  set oneproc = i386
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Darwin" && $proc == "i386" && $rele:r:r == 9) then
  set onesyst = Darwin
  set oneproc = i386
  set onearch = $onesyst-$oneproc
  set fixldcycle = 1    # Apple-approved hack ldflag to fix link err cycle
endif
if ($syst == "Darwin" && $proc == "i386" && $rele:r:r >= 10) then
  set onesyst = Darwin
  set oneproc = x86_64  # def on 32bitOS
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Darwin" && $proc == "arm64") then
  set onesyst = Darwin
  set oneproc = x86_64  # change to "arm64" when native-compile done
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Linux"  && $proc == "i386") then
  set onesyst = Linux
  set oneproc = i386
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Linux"  && $proc == "i686") then
  set onesyst = Linux
  set oneproc = i386
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Linux"  && $proc == "athlon") then
  set onesyst = Linux
  set oneproc = i386
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Linux"  && $proc == "unknown" && "$mach" == "i386") then
  set onesyst = Linux
  set oneproc = i386
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Linux"  && $proc == "unknown" && "$mach" == "i686") then
  set onesyst = Linux
  set oneproc = i386
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Linux"  && $proc == "x86_64") then
  set onesyst = Linux
  set oneproc = x86_64
  set onearch = $onesyst-$oneproc
endif
if ($syst == "Linux"  && $proc == "unknown" && "$mach" == "x86_64") then
  set onesyst = Linux
  set oneproc = x86_64
  set onearch = $onesyst-$oneproc
endif
if ($syst == "IRIX"   && $proc == "mips") then
  set onesyst = IRIX    # -n32 vs -32
  set oneproc = mips
  set onearch = $onesyst-$oneproc
endif
if ($syst == "IRIX64" && $proc == "mips") then
  set onesyst = IRIX    # -64
  set oneproc = mips
  set onearch = $onesyst-$oneproc
endif
# else onearch=unknown

### return known, onesyst, oneproc, or onearch
if ($#argv == 0) then
  echo $onearch
else
  if ($1 == "known") then
    foreach onearch ( $known )
      echo -n "$onearch "
    end
    echo ""
  endif
  if ($1 == "onesyst") echo $onesyst
  if ($1 == "oneproc") echo $oneproc
  if ($1 == "onearch") echo $onearch
  if ($1 == "fixldcycle") echo $fixldcycle
endif

