######################################################################
# crosscorr.tcl: searchlight cross-correlation for 9-position airpuff
######################################################################
# put this in subject's label subdir (will appear in "tcl:" dropdown)
# expects wfiles named like: P_${i}_C_GLT@0_Coef-clust+orig-$hemi.w
# generates matrix of searchlight cross correlations
# to run:
#   (1) open hemisphere (either) with SURFACE-STATS in a scandir
#   (2) select this script from "tcl:" dropdown
#   (3) GO

### xcorr parms
set fileneartype   0    ;# 0=num, 1=area(mm^2), 2=radius(mm)
set num,sqmm,mm  250    ;# inline comments need initial semicolon
set cmptype        0    ;# what to correlate: 0=real,real ...
set smoothsteps    5    ;# interface variable
set labelinfix SearchlightArea  ;# constrains searchlight centers

### initial user feedback pop-up, OK to start
confirmalert "scandir = $scandir\
            \nlabel = $hemi-$labelinfix.label\
            \nfillneartype = $fillneartype\
            \nnum,sqmm,mm = ${num,sqmm,mm}\
            \ncmptype = $cmptype\
            \nsmoothsteps = $smoothsteps"

### display parms
set overlayflag 1
make_lateral_view

### load data into val and valbak fields
for {set i 1} {$i <= 9} {incr i} {
  for {set j 1} {$j <= 9} {incr j} {

    ### just do upper right symmetric matrix of cross corr (no diagonal)
    if {$j <= $i} { continue }

    ### clear entire data stack at each vertex
    clear_values
    clear_valbaks
    clear_stats
    clear_pvals
    clear_uniqvoxdata

    ### set subject label to constrain spotlight centers (setfile: csurf glob)
    setfile label ~/label/$hemi-$labelinfix.label

    ### read and smooth first data set (need {} because '_' like a letter)
    setfile val */$scandir/P_${i}_C_GLT@0_Coef-clust+orig-$hemi.w
    read_binary_values
    smooth_val $smoothsteps
  
    ### move first down stack
    swap_valval2_valbakval2bak
  
    ### read and smooth second data set
    setfile val */$scandir/P_${j}_C_GLT@0_Coef-clust+orig-$hemi.w
    read_binary_values
    smooth_val $smoothsteps
  
    ### run xcorr (need {} because of comma's in variable)
    corr_over_label $fileneartype ${num,sqmm,mm} $cmptype

    ### swap xcorr to make it visible/saveable
    swap_stat_val
    redraw    ;# see progress

    ### recut label, write label file (ASCII) in scandir
    # first read uniq (goes into vertex data structure)
    setfile label */$scandir/$hemi-UniqSampVtxs.label
    read_uniqsamp_vertices
    # reset label variable for re-cut (re-cut so label not whole hemi)
    setfile label ~/label/$hemi-$labelinfix.label
    read_label_cut_clearvals 0
    # rest label variable again for write
    setfile label */$scandir/$hemi-P$i-xcorr-P$j.label
    write_labeled_vertices
    # restore surface (after showing just points, equals INIT button)
    restore_ripflags 2

    ### write binary valfile (*.w file) in scandir (zero vertices omitted)
    setfile val */$scandir/P$i-xcorr-P$j-$hemi.w
    write_binary_values

  }
}

