#! /usr/bin/tclsh
#############################################################################
# surfer script: curv-views  [display curvature on requested views]
##############################################################################
### wrap entire script so script errors/crashes can go to log
catch {

### tcl-only defs
set rgbname curv        ;# curv,sulc -- rgbfile name + sets display type

### C-parm defs
set overlayflag 0       ;# overlay data on gray brain
set surfcolor 1         ;# draw the curvature under data
set avgflag 1           ;# make half convex/concave
set cslope 3.0          ;# curv sigmoid steepness
set offset 0.30         ;# default lighting offset
set cvfact 1.30         ;# background light/dark curv gray contrast
set light2 0.8          ;# bakcompat: more top light (old tksurfer def=0.6)

### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(CSURF_DIR)/lib/tcl/readenv.tcl

### read curvature (or sulc)
puts "tksurfer: [file tail $script]: read curvature"
if { [string match *curv* $rgbname] } {
  read_binary_curv
} elseif { [string match *sulc* $rgbname] } {
  read_binary_sulc
} else {
  puts \
  "### tksurfer: [file tail $script]: $rgbname: bad type: curv/sulc not in name"
  exit
}

### scale and position brain
puts "tksurfer: [file tail $script]: scale, position brain"
open_window
make_lateral_view
do_lighting_model

### save requested rgbs
puts "tksurfer: [file tail $script]: save rgb's"
source $env(CSURF_DIR)/lib/tcl/saveviews.tcl

### errors (if any) to log
} ret 
if {$ret != ""} { puts "tksurfer: [file tail $script]: ### $ret" }

if ![info exists noexit] { exit }

