#! /usr/bin/tclsh
##############################################################################
# tksurfer script: offsetmovie     [save offset movie; interactive or batch]
##############################################################################
### N.B.: caller must init $userok to 0 (uses current surface pose)

### hard defaults
if ![info exists userok] { set userok 0 }

### parm defaults
if {!$userok} {  ;# don't blow away reset by controls
  if ![info exists rgbname] { set rgbname current }  ;# batch
  set rgbnameSAV $rgbname
  set offsetsteps 50   ;# was 25
  set offsetmin 0.0
  set offsetmax 1.0
  set makempg1_cleanup 0
  set justnumframes 0
}

### session tkmedit overlay
if { [info exists interfacefile] && $interfacefile == "tkmedit.tcl" } {
  set hemi both   ;# don't overlap tksurfer images
  set flag2d 0
  set surfext vol
}

### popup controls (always override nosave if on)
if ![info exists offsetmoviectrls] { set offsetmoviectrls "" }
if [winfo viewable .] {    ;# make popup
  if {!$userok} {
    if [winfo exists $offsetmoviectrls] { raise $offsetmoviectrls; return }
    set offsetmoviectrls [controls "SAVE OFFSET MOVIE" {
      rgbname offsetmin offsetmax offsetsteps makempg1_cleanup justnumframes
    } "RUN SCRIPT" "set userok 1; source [info script]" 20]
    bind $offsetmoviectrls <ButtonRelease-3> { helpwin script_offsetmovie }
    return
  }
} else {                   ;# batch scripts; re-read env to override defaults
  source $env(CSURF_DIR)/lib/tcl/readenv.tcl
}
if [info exists nosave] {puts "offsetmovie.tcl: nosave is set -- overriding it"}

### after possible override, since not currently catching wrap
if { $offsetmax < $offsetmin } {
  set m "offsetmovie.tcl:\
     \n\n    offsetmax less than offsetmin\
     \n\ncan't wrap offset, but offset>1.0 accepted:\
     \n\n    offset=1.05 equals offset=0.05\
       \n    so:  0.95 -> 1.05 works"
  if [winfo viewable .] { confirmalert $m } else { puts $m }
  prompt
  unset m
  return
}

### tmp reset named_rgbdir if detect abspath
set named_rgbdirSAV $named_rgbdir
if [string match /* $rgbname] {
  set named_rgbdir [file dirname $rgbname]
  set rgbname [file tail $rgbname]
}

### save offsetmovie frames
puts "offsetmovie.tcl: making movie of angle_offsets"
set imsuff rgb
if [info exists tiffoutflag] {
  if {$tiffoutflag} { set imsuff tiff }
}
puts "     files: $rgbname-offmov-$hemi-{currsurface}-???,of=+?.??.$imsuff"
prompt
raise_window
set angle_offset $offsetmin
set doff [expr ($offsetmax-$offsetmin)/$offsetsteps]
set i 0
for {set angle_offset $offsetmin} {$angle_offset < $offsetmax} \
    {set angle_offset [expr $angle_offset + $doff]} {
  redraw
  set rgbnum [format "%03d" $i]
  set offnum of=[format "%+2.2f" $angle_offset]
  set currext ""
  if {$justnumframes} {
    save_rgb_named f[format "%05d" $i].$imsuff
  } elseif {$flag2d} {
    set currext "flat"
    save_rgb_named $rgbname-offmov-$hemi-$currext-$rgbnum,$offnum.$imsuff
  } else {
    set currext $surfext
    save_rgb_named $rgbname-offmov-$hemi-$currext-$rgbnum,$offnum.$imsuff
  }
  incr i
}

### optional convert to quality=1 mpg, test show (50X compression)
if {$makempg1_cleanup && !$justnumframes} {
  puts "offsetmovie.tcl: making mpg, deleting frames when done"
  set dirSAV [pwd]
  cd $named_rgbdir
  set impatt $rgbname-offmov-$hemi-$currext-???,of=+?.??
  set mpgname $isession/mpg/$rgbname-offmov-$hemi-$currext.mpg
  if {$imsuff == "rgb"} {
    puts [eval exec rgb2mpg -q 1 $impatt.$imsuff $mpgname]
  }
  if {$imsuff == "tiff"} {
    puts [eval exec tiff2mpg -q 1 $impatt.$imsuff $mpgname]
  }
  puts [eval exec mpeg_play -dither color -quiet -loop $mpgname >& /dev/null &]
  foreach tmprgb [lsort [glob $impatt.$imsuff]] { exec rm $tmprgb }
  cd $dirSAV
}

### restore tksurfer vars
set named_rgbdir $named_rgbdirSAV
if [info exists rgbnameSAV] { set rgbname $rgbnameSAV }
set userok 0
#if [info exists offsetmoviectrls] { destroy $offsetmoviectrls }
return   ;# else catch returns err (=return of last command)

