#! /usr/local/bin/tclsh7.4
#############################################################################
# surfer script: inflate   [write folded,area,curv,inflate,sulc,optmovie]
#############################################################################
# 99/09/16: last UCSD (FreeSurfer0.7)
# 12/03/18: resurrect for bucky
#============================================================================
#TODO-OLD: allow slowstart + write surfs for later movie (see inflate-steps)

#### parm defaults: can reset in csh script with setenv
set MRIflag 0
#set mmid 45.0          ;# MRI force sigmoid zero (pos/neg)
#set mslope 0.125       ;# MRI force sigmoid steepness
#set mstrength 0.125    ;# MRI force strength
set areaflag 0          ;# start turned off
set wa 1.0              ;# area
set ws 0.5              ;# tangential
set wn 0.4              ;# normal
set origsteps 20        ;# orig surface smooth steps
set curvsteps 5         ;# curvature smooth steps
set wmsuffix smoothwm   ;# smoothed white matter name
set origsuffix orig     ;# smoothed white matter name
set ishrinksteps 10     ;# shrink steps (init,area) between normalize
set initcycles 20       ;# initial inflate cycles
set initsuffix 1000     ;# initial inflate name (std:200 steps)
set areacycles 30       ;# area-corrected inflate cycles
set areasuffix inflated ;# area-corrected inflate name (std:300 addtl steps)
set skiparea 0          ;# 1 (true) for quicker test

#### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(MRI_DIR)/lib/tcl/readenv.tcl

### write smoothed white matter surface
puts "tksurfer: [file tail $script]: write smoothed white matter"
shrink $origsteps   ;# slight smoothing
setfile outsurf ~/surf/$hemi.$wmsuffix
write_binary_surface

### folded local cortical area estimate
puts "tksurfer: [file tail $script]: write initial area estimate"
write_binary_areas

### curvature coloring
puts "tksurfer: [file tail $script]: compute, write curvature"
compute_curvature
smooth_curv $curvsteps     ;# slight smooth before write
write_binary_curv
clear_curvature

### initial inflation
puts "tksurfer: [file tail $script]: initial inflation (no area correct)"
set sulcflag 1      ;# begin summing perpendicular movement ('sulcus' coloring)
set momentumflag 1
set i 0
while {$i < $initcycles} {
  shrink $ishrinksteps
  normalize_area
  incr i
  puts "###### $hemi: [expr $ishrinksteps*$i] of [expr $ishrinksteps*$initcycles] initial inflate steps ######"
}

### write sulc, surface only if quickie
smooth_curv $curvsteps   ;# slight smooth before write
write_binary_sulc   ;# sulcus coloring (incl area correct?)
if {$skiparea} {
  puts "tksurfer: [file tail $script]: write init surface for topology test"
  setfile outsurf ~/surf/$hemi.$initsuffix
  write_binary_surface
  if ![info exists noexit] { exit } else { return } 
} else {
  setfile outsurf ~/surf/$hemi.$areasuffix
  write_binary_surface
  puts "tksurfer: [file tail $script]: write tmp test surf (overwritten later)"
}

### final area-correct inflate
puts "tksurfer: [file tail $script]: final inflation (area correct)"
set areaflag 1      ;# retain original area 
set ncthreshflag 1  ;# normal component thresh (allow slight rumpling) 
set i 0
while {$i < $areacycles} {
  shrink $ishrinksteps
  normalize_area
  incr i
  puts "###### $hemi: [expr $ishrinksteps*$i] of [expr $ishrinksteps*$areacycles] area-corrected steps #######"
}

### write surface
puts "tksurfer: [file tail $script]: write final surface"
setfile outsurf ~/surf/$hemi.$areasuffix
write_binary_surface

if ![info exists noexit] { exit }

